﻿using UnityEngine;
using System.Collections;

public class MenuScript : MonoBehaviour
{
    public Texture2D titleSplash;
    public Vector4 titleSplashRelativePosition;
    public Vector4 titleRelativePosition;
    public Vector4 menuRelativePosition;

    private GUIStyle buttonStyle;
    private GUIStyle titleStyle;
    private GUIStyle shadowTitleStyle;
    public float shadowOffset;
    public Font basicFont;
    public Font titleFont;
	// Use this for initialization
	void Start () {
	
        buttonStyle = new GUIStyle();
	    buttonStyle.font = basicFont;
	    buttonStyle.normal.textColor = Color.white;

        titleStyle = new GUIStyle();
	    titleStyle.font = titleFont;
	    titleStyle.normal.textColor = new Color(255f / 255f, 195f / 255f, 184f / 255f);

        shadowTitleStyle = new GUIStyle();
        shadowTitleStyle.font = titleFont;
        shadowTitleStyle.normal.textColor = Color.black;
	}
	
	// Update is called once per frame
	void Update ()
	{
	}

    void OnGUI()
    {

        var h = Screen.height;
        var w = Screen.width;

        var splashRect = new Rect(titleSplashRelativePosition.x*w, titleSplashRelativePosition.y*h,
            titleSplashRelativePosition.z*w, titleSplashRelativePosition.w*h);

        GUI.DrawTexture(splashRect,titleSplash);

        var titleRect = new Rect(titleRelativePosition.x*w, titleRelativePosition.y*h,
            titleRelativePosition.z*w, titleRelativePosition.w*h);

        var shadowTitleRect = new Rect((titleRelativePosition.x + shadowOffset) * w, (titleRelativePosition.y + shadowOffset)* h,
           (titleRelativePosition.z+ shadowOffset) * w, (titleRelativePosition.w+ shadowOffset) * h);

        GUI.Label(shadowTitleRect, "super \nANGRY BOWSER", shadowTitleStyle);
        GUI.Label(titleRect, "super \nANGRY BOWSER", titleStyle);

        var menuRect = new Rect(menuRelativePosition.x * w, menuRelativePosition.y * h,
            menuRelativePosition.z * w, menuRelativePosition.w * h);

        if (GUI.Button(menuRect, "Press Here to Start", buttonStyle))
        {
            Application.LoadLevel(1);
        }
    }
}
